--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A simple trio of floating-point numbers.
--- @class tes3vector3
--- @operator add(number): tes3vector3
--- @operator add(tes3vector3): tes3vector3
--- @operator div(number): tes3vector3
--- @operator len: number
--- @operator mul(tes3vector3): tes3vector3
--- @operator mul(number): tes3vector3
--- @operator sub(number): tes3vector3
--- @operator sub(tes3vector3): tes3vector3
--- @operator unm: tes3vector3
--- @field b number The third value in the vector. An alias for `z`.
--- @field g number The second value in the vector. An alias for `y`.
--- @field r number The first value in the vector. An alias for `x`.
--- @field x number The first value in the vector.
--- @field y number The second value in the vector.
--- @field z number The third value in the vector.
tes3vector3 = {}

--- Creates a new vector. If no parameters are provided, an empty set will be constructed.
--- @param x? number *Default*: `0`. No description yet available.
--- @param y? number *Default*: `0`. No description yet available.
--- @param z? number *Default*: `0`. No description yet available.
--- @return tes3vector3 vector No description yet available.
function tes3vector3.new(x, y, z) end

--- Creates a new vector with all components set to 1.
--- @return tes3vector3 vector No description yet available.
function tes3vector3.ones() end

--- Creates a new vector pointing along the positive X axis.
--- @return tes3vector3 vector No description yet available.
function tes3vector3.unitX() end

--- Creates a new vector pointing along the positive Y axis.
--- @return tes3vector3 vector No description yet available.
function tes3vector3.unitY() end

--- Creates a new vector pointing along the positive Z axis.
--- @return tes3vector3 vector No description yet available.
function tes3vector3.unitZ() end

--- Creates a new vector with all components set to 0.
--- @return tes3vector3 vector No description yet available.
function tes3vector3.zeroes() end

--- Converts the vector to a string with 2 decimal places.
--- @return string result No description yet available.
function tes3vector3:__tostring() end

--- The returns the angle between the two vectors in radians.
--- @param vec tes3vector3 No description yet available.
--- @return number result No description yet available.
function tes3vector3:angle(vec) end

--- Creates a copy of the vector.
--- @return tes3vector3 result No description yet available.
function tes3vector3:copy() end

--- Calculates the cross product with another vector.
--- @param vec tes3vector3 No description yet available.
--- @return tes3vector3 result No description yet available.
function tes3vector3:cross(vec) end

--- Calculates the distance to another vector in the standard way, i.e., using the [Euclidean distance](https://en.wikipedia.org/wiki/Euclidean_distance).
--- @param vec tes3vector3 No description yet available.
--- @return number result No description yet available.
function tes3vector3:distance(vec) end

--- Calculates the distance to another vector, using the [Chebyshev metric](https://en.wikipedia.org/wiki/Chebyshev_distance), which is defined as
--- 
--- 	math.max(math.abs(v1.x - v2.x), math.abs(v1.y - v2.y), math.abs(v1.z - v2.z))
--- 
--- This is useful for ensuring that the x, y, and z coordinates between two vectors are all (independently) within a certain distance from each other.
--- 
--- Here is a geometric description of the difference between the normal distance and the Chebyshev distance for two `tes3vector3`s  `v1` and `v2`:
--- 
--- * If `v1:distance(v2) <= 1`, then `v2` is contained in a sphere around `v1` with radius 1 (i.e. diameter 2).
--- * If `v1:distanceChebyshev(v2) <= 1`, then `v2` is contained within a cube centered around `v1`, where the cube has length 2.
--- 
--- @param vec tes3vector3 No description yet available.
--- @return number result No description yet available.
function tes3vector3:distanceChebyshev(vec) end

--- Calculates the distance to another vector, using the [Manhattan (i.e. city block) metric](https://en.wikipedia.org/wiki/Taxicab_geometry). 
--- In the two-dimensional case, the Manhattan metric can be thought of 
--- as the distance that two taxis will have to travel if they're following a grid system.
--- The formula for the Manhattan distance is
--- 
--- 	math.abs(v1.x - v2.x) + math.abs(v1.y - v2.y) + math.abs(v1.z - v2.z)
--- 
--- This is useful for checking how far you'd actually have to move if you're only allowed to move along one axis at a time.
--- 
--- @param vec tes3vector3 No description yet available.
--- @return number result No description yet available.
function tes3vector3:distanceManhattan(vec) end

--- Calculates the distance between the XY-coordinates of two vectors.
--- 
--- This method offers a way of calculating distances between vectors in situations where it's more convenient to ignore the z-coordinates.
--- 
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/types/tes3vector3/#distancexy).
--- @param vec tes3vector3 No description yet available.
--- @return number result No description yet available.
function tes3vector3:distanceXY(vec) end

--- Calculates the dot product with another vector.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/types/tes3vector3/#dot).
--- @param vec tes3vector3 No description yet available.
--- @return number result No description yet available.
function tes3vector3:dot(vec) end

--- Calculates the vertical distance to another vector.
--- @param vec tes3vector3 No description yet available.
--- @return number result No description yet available.
function tes3vector3:heightDifference(vec) end

--- Calculates the interpolated position against the target vector using the `distance` parameter.
--- @param targetPoint tes3vector3 No description yet available.
--- @param distance number No description yet available.
--- @return tes3vector3 result No description yet available.
function tes3vector3:interpolate(targetPoint, distance) end

--- Calculates the length of the vector.
--- @return number result No description yet available.
function tes3vector3:length() end

--- Calculates the interpolated vector between this vector and another, given a transition.
--- @param toVector tes3vector3 The vector to interpolate towards.
--- @param transition number The interpolation value. Must be between `0.0` (closer to this vector) and `1.0` (closer to the other vector).
--- @return tes3vector3 lerpedVector The calculated value.
function tes3vector3:lerp(toVector, transition) end

--- Returns a vector containing the maximum values for each component of the given vectors.
--- @param other tes3vector3 No description yet available.
--- @return tes3vector3 result No description yet available.
function tes3vector3:max(other) end

--- Returns a vector containing the minimum values for each component of the given vectors.
--- @param other tes3vector3 No description yet available.
--- @return tes3vector3 result No description yet available.
function tes3vector3:min(other) end

--- Negates all values in the vector.
function tes3vector3:negate() end

--- Normalize the vector in-place, or set its components to zero if normalization is not possible. Returns `true` if the vector was successfully normalized.
--- @return boolean result No description yet available.
function tes3vector3:normalize() end

--- Get a normalized copy of the vector.
--- @return tes3vector3 result No description yet available.
function tes3vector3:normalized() end

--- Calculates the outer product with another vector.
--- @param vec tes3vector3 No description yet available.
--- @return tes3matrix33 result No description yet available.
function tes3vector3:outerProduct(vec) end

--- Converts the vector to `niColor` object.
--- @return niColor result No description yet available.
function tes3vector3:toColor() end

